/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lotr.common.LOTRCreativeTabs;
import lotr.common.item.LOTRItemArmor;
import lotr.common.item.LOTRMaterial;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class LOTRItemLeatherHat
extends LOTRItemArmor {
    public static final int HAT_LEATHER = 6834742;
    public static final int HAT_SHIRRIFF_CHIEF = 2301981;
    public static final int FEATHER_WHITE = 0xFFFFFF;
    public static final int FEATHER_SHIRRIFF_CHIEF = 0x339919;
    public static final int HAT_BLACK = 0;
    @SideOnly(value=Side.CLIENT)
    private IIcon featherIcon;

    public LOTRItemLeatherHat() {
        super(LOTRMaterial.COSMETIC, 0);
        this.func_77637_a(LOTRCreativeTabs.tabMisc);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        super.func_94581_a(iconregister);
        this.featherIcon = iconregister.func_94245_a(this.func_111208_A() + "_feather");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemstack, int pass) {
        if (pass == 1 && LOTRItemLeatherHat.hasFeather(itemstack)) {
            return this.featherIcon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemstack, int pass) {
        if (pass == 1 && LOTRItemLeatherHat.hasFeather(itemstack)) {
            return LOTRItemLeatherHat.getFeatherColor(itemstack);
        }
        return LOTRItemLeatherHat.getHatColor(itemstack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (LOTRItemLeatherHat.isHatDyed(itemstack)) {
            list.add(StatCollector.func_74838_a((String)"item.lotr.hat.dyed"));
        }
        if (LOTRItemLeatherHat.hasFeather(itemstack)) {
            list.add(StatCollector.func_74838_a((String)"item.lotr.hat.feathered"));
        }
    }

    public static int getHatColor(ItemStack itemstack) {
        int dye = LOTRItemLeatherHat.getSavedDyeColor(itemstack);
        if (dye != -1) {
            return dye;
        }
        return 6834742;
    }

    private static int getSavedDyeColor(ItemStack itemstack) {
        if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("HatColor")) {
            return itemstack.func_77978_p().func_74762_e("HatColor");
        }
        return -1;
    }

    public static boolean isHatDyed(ItemStack itemstack) {
        return LOTRItemLeatherHat.getSavedDyeColor(itemstack) != -1;
    }

    public static ItemStack setHatColor(ItemStack itemstack, int i) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("HatColor", i);
        return itemstack;
    }

    public static int getFeatherColor(ItemStack itemstack) {
        int i = -1;
        if (itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74764_b("FeatherColor")) {
            i = itemstack.func_77978_p().func_74762_e("FeatherColor");
        }
        return i;
    }

    public static boolean hasFeather(ItemStack itemstack) {
        return LOTRItemLeatherHat.getFeatherColor(itemstack) != -1;
    }

    public static boolean isFeatherDyed(ItemStack itemstack) {
        return LOTRItemLeatherHat.hasFeather(itemstack) && LOTRItemLeatherHat.getFeatherColor(itemstack) != 0xFFFFFF;
    }

    public static ItemStack setFeatherColor(ItemStack itemstack, int i) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("FeatherColor", i);
        return itemstack;
    }

    public static void removeHatAndFeatherDye(ItemStack itemstack) {
        if (itemstack.func_77978_p() != null) {
            itemstack.func_77978_p().func_82580_o("HatColor");
        }
        if (LOTRItemLeatherHat.hasFeather(itemstack) && LOTRItemLeatherHat.isFeatherDyed(itemstack)) {
            LOTRItemLeatherHat.setFeatherColor(itemstack, 0xFFFFFF);
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "lotr:armor/hat.png";
    }
}

